/*
 * utils.cpp - see utils.h for "details"
 * checker@d6.com
 *
 */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <assert.h>
#include "utils.h"
#include <map>

using namespace std;

/********************************* GetTime **********************************/

double GetTime( void )
{
   static __int64 unsigned Frequency;
   static __int64 unsigned StartTime;
   static int Init = 1;
   __int64 unsigned Timer;

   if(Init)
   {
      QueryPerformanceFrequency((LARGE_INTEGER*)&Frequency);
      QueryPerformanceCounter((LARGE_INTEGER*)&StartTime);
      Init = 0;
      return 0.0;
   }
   else
   {
      QueryPerformanceCounter((LARGE_INTEGER*)&Timer);
      return ((double)(Timer-StartTime)/(double)(Frequency));
   }
}

__int64 unsigned RDTSC( void )
{
   __int64 unsigned cur_rdtsc;
   _asm {
      xor eax, eax;
      xor edx, edx;
      lea ecx, cur_rdtsc;
      rdtsc;
      mov [ecx+0], eax;
      mov [ecx+4], edx;
   }
   return cur_rdtsc;
}

/********************************** assert **********************************/
// c++ sucks
typedef pair<char const*,unsigned> _assert_key_type;
struct _assert_lt_key_type {
   bool operator()( _assert_key_type const &a, _assert_key_type const &b ) const
      {
         if(a.second == b.second) {
            return strcmp(a.first,b.first) < 0;
         } else {
            return a.second < b.second;
         }
      }
};
#if _MSC_VER >= 1300
extern "C" void __cdecl _assert( char const *pExpression, char const *pFile, unsigned LineNumber )
#else 
extern "C" void __cdecl _assert( void *pExpression, void *pFile, unsigned LineNumber )
#endif
{
   static map<_assert_key_type,bool,_assert_lt_key_type> ignore_map;

   char buffer[500];
   _assert_key_type key((char const *)pFile,LineNumber);
   
   if((ignore_map.count(key) > 0) &&
      ignore_map[key])
   {
      return;
   }
   
   wsprintf(buffer,"Assertion: %s\nFile: %s, Line: %d\n" \
            "Hit Abort to exit, Retry to debug, Ignore to continue",
            pExpression,pFile,LineNumber);
   
   switch(MessageBox(0,buffer,"Assert!",MB_ABORTRETRYIGNORE | MB_ICONHAND)) {
      case IDABORT:
      {
         exit(0);
         break;
      }
      case IDRETRY:
      {
         DebugBreak();
         break;
      }
      case IDIGNORE:
      {
         if(MessageBox(0,"Ignore Forever?","Ignore Assert",MB_YESNO) == IDYES) {
            ignore_map[key] = true;
         }
         break;  
      }
   }
}

/**************************** open/save filename ****************************/

bool GetLoadSaveFilename( char *filename, bool Load, char const *filter )
{
   char Path[_MAX_PATH];
   GetFullPathName(filename,sizeof(Path),Path,0);
   OPENFILENAME ofn = { sizeof(OPENFILENAME) };
   ofn.lpstrFilter = filter;
   ofn.lpstrFile = Path;
   ofn.nMaxFile = _MAX_PATH;
   ofn.Flags = Load ? OFN_FILEMUSTEXIST : OFN_OVERWRITEPROMPT;

   if(Load) {
      if(GetOpenFileName(&ofn)) {
         strcpy(filename,Path);
         return true;
      } else {
         return false;
      }
   } else {
      if(GetSaveFileName(&ofn)) {
         strcpy(filename,Path);
         return true;
      } else {
         return false;
      }
   }      
}

