#ifndef UTILS_H
#define UTILS_H


/******************************* system stuff ********************************/

double GetTime( void );             // sub-microsecond accurate time in seconds
__int64 unsigned RDTSC( void );               // read time stamp counter
bool GetLoadSaveFilename( char *filename, bool Load, char const *filter );

/********************************** verify **********************************/

#ifndef _CRTIMP
#ifdef  _DLL
#define _CRTIMP __declspec(dllimport)
#else   /* ndef _DLL */
#define _CRTIMP
#endif  /* _DLL */
#endif  /* _CRTIMP */

#undef  verify

#ifdef  NDEBUG

#define verify(exp)     (exp)

#else  // NDEBUG

#ifdef  __cplusplus
extern "C" {
#endif
_CRTIMP void __cdecl _assert(const char *, const char *, unsigned);
#ifdef  __cplusplus
}
#endif

#define verify(exp) (void)( (exp) || (_assert(" verify( " #exp " )", __FILE__, __LINE__), 0) )

#endif  /* NDEBUG */

#endif // UTILS_H
